/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.rep.server;

import com.ibm.hsc.rep.server.RxConnection;
import java.util.Hashtable;
import java.util.Vector;

public class RxConnectionPool {
    private static Hashtable poolHash = new Hashtable();
    String mHostname;
    int mPort;
    Vector mAvailVec = new Vector();
    int mPoolSize = 0;

    private RxConnectionPool(String string, int n, int n2) throws Exception {
        this.mHostname = string;
        this.mPort = n;
        this.mPoolSize = n2;
        int n3 = 0;
        while (n3 < this.mPoolSize) {
            RxConnection rxConnection = new RxConnection(string, n);
            this.mAvailVec.add(rxConnection);
            rxConnection.open();
            ++n3;
        }
    }

    private void setPoolSize(int n) {
        this.mPoolSize = n;
    }

    public static RxConnectionPool getConnectionPool(String string, int n, int n2) throws Exception {
        String string2 = string + n;
        RxConnectionPool rxConnectionPool = (RxConnectionPool)poolHash.get(string2);
        if (rxConnectionPool == null) {
            rxConnectionPool = new RxConnectionPool(string, n, n2);
            poolHash.put(string2, rxConnectionPool);
        }
        return rxConnectionPool;
    }

    public boolean hasAvailable() {
        return this.mAvailVec.size() > 0;
    }

    public synchronized RxConnection obtainConnection() throws Exception {
        RxConnection rxConnection = null;
        if (this.mAvailVec.size() > 0) {
            rxConnection = (RxConnection)this.mAvailVec.remove(this.mAvailVec.size() - 1);
        }
        return rxConnection;
    }

    public synchronized void releaseConnection(RxConnection rxConnection) {
        this.mAvailVec.add(rxConnection);
    }

    public String toString() {
        return this.mHostname + this.mPort;
    }

    public int hashCode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.mHostname);
        stringBuffer.append("%");
        stringBuffer.append(this.mPort);
        return stringBuffer.toString().hashCode();
    }

    public boolean equals(Object object) {
        RxConnectionPool rxConnectionPool = (RxConnectionPool)object;
        return this.mHostname.equalsIgnoreCase(rxConnectionPool.mHostname) && this.mPort == rxConnectionPool.mPort;
    }
}

